/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.demos;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.python.indexer.StyleRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StyleApplier {
    private static final int SOURCE_BUF_MULTIPLIER = 6;
    private SortedSet<Tag> tags = new TreeSet<Tag>();
    private StringBuilder buffer;
    private String source;
    private String path;
    private int sourceOffset = 0;

    public StyleApplier(String string, String string2, List<StyleRun> list) {
        this.path = string;
        this.source = string2;
        for (StyleRun styleRun : list) {
            this.tags.add(new StartTag(styleRun));
            this.tags.add(new EndTag(styleRun));
        }
    }

    public String apply() {
        this.buffer = new StringBuilder(this.source.length() * 6);
        int n = -1;
        for (Tag tag : this.tags) {
            tag.insert();
        }
        if (this.sourceOffset < this.source.length()) {
            this.copySource(this.sourceOffset, this.source.length());
        }
        return this.buffer.toString();
    }

    private void copySource(int n, int n2) {
        try {
            String string = this.escape(n2 == -1 ? this.source.substring(n) : this.source.substring(n, n2));
            this.buffer.append(string);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Warning: " + runtimeException);
        }
        this.sourceOffset = n2;
    }

    private String escape(String string) {
        return string.replace("&", "&amp;").replace("'", "&#39;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private String toCSS(StyleRun styleRun) {
        return styleRun.type.toString().toLowerCase().replace("_", "-");
    }

    class EndTag
    extends Tag {
        public EndTag(StyleRun styleRun) {
            this.offset = styleRun.end();
            this.style = styleRun;
        }

        void insert() {
            super.insert();
            switch (this.style.type) {
                case ANCHOR: 
                case LINK: {
                    StyleApplier.this.buffer.append("</a>");
                    break;
                }
                default: {
                    StyleApplier.this.buffer.append("</span>");
                }
            }
        }
    }

    class StartTag
    extends Tag {
        public StartTag(StyleRun styleRun) {
            this.offset = styleRun.start();
            this.style = styleRun;
        }

        void insert() {
            super.insert();
            switch (this.style.type) {
                case ANCHOR: {
                    StyleApplier.this.buffer.append("<a name='");
                    StyleApplier.this.buffer.append(this.style.url);
                    break;
                }
                case LINK: {
                    StyleApplier.this.buffer.append("<a href='");
                    StyleApplier.this.buffer.append(this.style.url);
                    break;
                }
                default: {
                    StyleApplier.this.buffer.append("<span class='");
                    StyleApplier.this.buffer.append(StyleApplier.this.toCSS(this.style));
                }
            }
            StyleApplier.this.buffer.append("'");
            if (this.style.message != null) {
                StyleApplier.this.buffer.append(" title='");
                StyleApplier.this.buffer.append(this.style.message);
                StyleApplier.this.buffer.append("'");
            }
            StyleApplier.this.buffer.append(">");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class Tag
    implements Comparable<Tag> {
        int offset;
        StyleRun style;

        Tag() {
        }

        @Override
        public int compareTo(Tag tag) {
            if (this == tag) {
                return 0;
            }
            if (this.offset < tag.offset) {
                return -1;
            }
            if (tag.offset < this.offset) {
                return 1;
            }
            return this.hashCode() - tag.hashCode();
        }

        void insert() {
            if (this.offset > StyleApplier.this.sourceOffset) {
                StyleApplier.this.copySource(StyleApplier.this.sourceOffset, this.offset);
            }
        }
    }
}

